import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * Beschreibung
  *
  * @version 1.0 vom 28.03.2013
  * @author vom Hau
  */

public class MultiplikationAnwendung extends JFrame {
  // Anfang Attribute
  private EinAus ein, aus;
  private JButton btVerschluesseln = new JButton();
  private JButton btEnde = new JButton();
  private JLabel jLabel1 = new JLabel();
  private JNumberField nfPrimzahl = new JNumberField();
  private JLabel jLabel2 = new JLabel();
  private JNumberField nfSchluessel = new JNumberField();
  private JButton btGeeignet = new JButton();
  private JLabel lbAntwort = new JLabel();
  // Ende Attribute
  
  public MultiplikationAnwendung(String title) {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 332; 
    int frameHeight = 182;
    setSize(frameWidth, frameHeight);
    
    setLocation(50, 100);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    btVerschluesseln.setBounds(7, 83, 104, 26);
    btVerschluesseln.setText("verschlsseln");
    btVerschluesseln.setMargin(new Insets(2, 2, 2, 2));
    btVerschluesseln.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btVerschluesseln_ActionPerformed(evt);
      }
    });
    btVerschluesseln.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(btVerschluesseln);
    btEnde.setBounds(204, 123, 104, 26);
    btEnde.setText("Ende");
    btEnde.setMargin(new Insets(2, 2, 2, 2));
    btEnde.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        ein.dispose(); aus.dispose();
        System.exit(0);
      }
    });
    btEnde.setFont(new Font("Dialog", Font.BOLD, 12));
    cp.add(btEnde);
    setTitle("Monoalphabetische Substitution");
    jLabel1.setBounds(8, 8, 59, 25);
    jLabel1.setText("Primzahl");
    cp.add(jLabel1);
    nfPrimzahl.setBounds(80, 8, 57, 25);
    nfPrimzahl.setText("677");
    cp.add(nfPrimzahl);
    jLabel2.setBounds(152, 8, 83, 25);
    jLabel2.setText("Schlsselzahl");
    cp.add(jLabel2);
    nfSchluessel.setBounds(248, 8, 57, 25);
    nfSchluessel.setText("7");
    cp.add(nfSchluessel);
    btGeeignet.setBounds(8, 48, 73, 25);
    btGeeignet.setText("geeignet?");
    btGeeignet.setMargin(new Insets(2, 2, 2, 2));
    btGeeignet.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        btGeeignet_ActionPerformed(evt);
      }
    });
    cp.add(btGeeignet);
    lbAntwort.setBounds(96, 48, 219, 25);
    lbAntwort.setText("R");
    cp.add(lbAntwort);
    // Ende Komponenten
    ein = new EinAus("Eingabe");
    aus = new EinAus("Ausgabe");
    aus.setLocation(470,420);
    ein.schreibeZeile("TESTTEXT");
    setVisible(true);
  } // end of public MultiplikationAnwendung
  
  // Anfang Methoden
  public void btVerschluesseln_ActionPerformed(ActionEvent evt) {
    String einString, ausString;
    String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    char zeichen; int nr, nr2;
    long pz, schl, inv;

    pz = nfPrimzahl.getLong();
    schl = nfSchluessel.getLong();
    if (istPrimzahl(pz) && (pz > 676) && (schl > 1) && (schl < pz)){
    
      einString = ein.getZeile(0);
      if (einString.length() % 2 == 1) einString = einString + "Z";
      ausString = "";                                 // gerade Laenge

      for (int i=0; i <einString.length()/2 ;i++ ) {
        zeichen = einString.charAt(2*i);
        nr = alphabet.indexOf( zeichen);
        if (nr > -1) {
          zeichen = einString.charAt(2*i+1);
          nr2 = alphabet.indexOf( zeichen);
          if (nr2 > -1) {
            nr = nr*26 + nr2;
            ausString = ausString + Long.toString((nr*schl) % pz)+";";
          }
          else ausString = ausString + "Fehler";
        } // end of if
        else ausString = ausString + "Fehler";

      } // end of for
    aus.schreibeZeile(ausString);
    }
  } // end of btVerschluesseln_ActionPerformed
  
  public void btGeeignet_ActionPerformed(ActionEvent evt) {
    long pz, schl, inv;
    
    pz = nfPrimzahl.getLong();
    schl = nfSchluessel.getLong();
    if (istPrimzahl(pz) && (pz > 676)){
      inv = inversebestimmen (schl, pz);
      lbAntwort.setText("geeignet; Inverse: " + Long.toString(inv));
    }
    else lbAntwort.setText("nicht geeignet");
  }

  public boolean istPrimzahl (long p){
    boolean ist; long i;
    
    ist = true; i = 2;
    while (ist && (i <= Math.sqrt(p))){
      if (p % i == 0) ist = false;
      i++;
    }
    return ist;
  }
  public long ggT (long a, long b) {
    while (a != b) {
      if (a<b) b = b - a;
      else a = a - b;
    }
    return a;
  }

  public long inversebestimmen (long z, long mo) {
    long a, b, q, r, inv, alt_a_z, alt_a_mo;
    long a_z, a_mo, b_z, b_mo;
    
    inv = 0;
    if (ggT(mo, z) == 1){
      a = mo;  b = z;
      a_z = 0; a_mo = 1;  // a = a_z * z + a_mo * mo
      b_z = 1; b_mo = 0;  // b = b_z * z + b_mo * mo
      
      while (b != 1) {
        q = a / b;
        r = a % b;        // oder  r = a - q b
        alt_a_z = a_z; alt_a_mo = a_mo;
        a_z = b_z; a_mo = b_mo;
        b_z = alt_a_z - q * a_z; b_mo = alt_a_mo - q * a_mo;
        a = b;
        b = r;
      }
      
      // jetzt ist b = 1 = b_z * z (+ b_mo * mo)
      // also ist b_z die Inverse zu b
      inv = b_z;
      if (inv < 0) inv = inv + mo;
    }
    return inv;
  }


  public static void main(String[] args) {
    new MultiplikationAnwendung("MultiplikationAnwendung");
  } // end of main
  
} // end of class MonoAlphAnwendung
